#![allow(dead_code)]

extern crate fun;

mod object;
mod side;

use fun::input::Keyboard;
use fun::math::Rotation;
use fun::math::Vector;
use fun::render::Render;
use fun::render::window;
use object::Battle;

static mut LEFT_SHAKE: bool = false;
static mut LEFT_SHAKE_GROUND: bool = false;
static mut LEFT_FLAG_HEIGHT: f32 = 0.0;
static mut LEFT_PRAY: bool = false;
static mut LEFT_FOOTBALL_POSITION: (f32, f32) = (0.0, 0.0);
static mut LEFT_KICK: bool = false;
static mut LEFT_HAS_BALL: bool = false;
static mut LEFT_THREW_BALL: bool = false;
static mut RIGHT_SHAKE: bool = false;
static mut RIGHT_SHAKE_GROUND: bool = false;
static mut RIGHT_FLAG_HEIGHT: f32 = 0.0;
static mut RIGHT_PRAY: bool = false;
static mut RIGHT_FOOTBALL_POSITION: (f32, f32) = (0.0, 0.0);
static mut RIGHT_KICK: bool = false;
static mut RIGHT_HAS_BALL: bool = false;
static mut RIGHT_THREW_BALL: bool = false;

fn reset() {
    unsafe {
        LEFT_SHAKE = false;
        LEFT_SHAKE_GROUND = false;
        LEFT_FLAG_HEIGHT = 0.0;
        LEFT_PRAY = false;
        LEFT_FOOTBALL_POSITION = (0.0, 0.0);
        LEFT_KICK = false;
        LEFT_HAS_BALL = false;
        LEFT_THREW_BALL = false;
        RIGHT_SHAKE = false;
        RIGHT_SHAKE_GROUND = false;
        RIGHT_FLAG_HEIGHT = 0.0;
        RIGHT_PRAY = false;
        RIGHT_FOOTBALL_POSITION = (0.0, 0.0);
        RIGHT_KICK = false;
        RIGHT_HAS_BALL = false;
        RIGHT_THREW_BALL = false;
    }

    let mut camera = unsafe { &mut::fun::global::CAMERA };

    camera.orientation.position = Vector::new(0.0, 2.0, 0.0);
    camera.orientation.rotation = Rotation::new(-0.01, 0.0, 0.0);
}

fn main() {
    let window = window::new("Superpatriots", (3000, 3000));
    let mut render = Render::new(&window);
    let mut keyboard = Keyboard::new();
    let mut battle = Battle::new();
    let mut camera = unsafe { &mut::fun::global::CAMERA };
    let mut timer = unsafe { &mut ::fun::global::TIMER };

    reset();

    loop {
        timer.begin_frame();

        {   // update
            keyboard.update(window.poll_events());

            if keyboard.escape() {
                return
            }

            if keyboard.reset_camera.pressed {
                reset();
                battle = Battle::new();
            }

            camera.update(&keyboard);

            let players = keyboard.players();

            battle.update(&players);
        }

        {   // draw
            render.start();

            for object in battle.objects_ref() {
                for mesh in object.meshes() {
                    let position = *object.position();
                    let rotation = *object.rotation();

                    render.draw(mesh, position, rotation);
                }
            }

            render.end();
        }

        timer.end_frame();
    }
}
