use fun::object::Object;
use fun::object::Scene;

pub struct Battle {
    objects: Vec<Box<Object>>,
}

impl Battle {
    pub fn new() -> Box<Scene> {
        Box::new(Battle {
            objects: {
                use super::Flag;
                use super::Ground;
                use super::Patriot;
                use ::side::Side::*;

                let ground = Ground::new();
                let left_patriot = Patriot::new(Left);
                let left_flag = Flag::new(Left);
                let right_patriot = Patriot::new(Right);
                let right_flag = Flag::new(Right);

                vec![
                    ground,
                    left_patriot,
                    left_flag,
                    right_patriot,
                    right_flag,
                ]
            },
        })
    }
}

impl Scene for Battle {
    fn objects_ref(&self) -> &Vec<Box<Object>> {
        &self.objects
    }

    fn objects_mut(&mut self) -> &mut Vec<Box<Object>> {
        &mut self.objects
    }
}
