use fun::input::Joystick;
use fun::object::Object;
use fun::object::Transform;
use fun::render::Mesh;

pub struct Firework {
    transform: Transform,
    mesh: Mesh,
    time: f32,
    dead: bool,
}

impl Firework {
    pub fn new (transform: Transform, mesh: Mesh) -> Box<Object> {
        Box::new(Firework {
            transform: transform,
            mesh: mesh,
            time: 0.0,
            dead: false,
        })
    }
}

impl Object for Firework {
    fn transform_ref(&self) -> &Transform {
        &self.transform
    }

    fn transform_mut(&mut self) -> &mut Transform {
        &mut self.transform
    }

    fn meshes(&self) -> Vec<&Mesh> {
        vec![&self.mesh]
    }

    fn remove(&self) -> bool {
        self.dead
    }

    fn update(&mut self, _: &(Joystick, Joystick)) {
        const MAX_TIME: f32 = 70.0;

        self.time += unsafe { &::fun::global::TIMER }.delta;

        if self.time > MAX_TIME {
            self.dead = true;
        }
    }
}
