pico-8 cartridge // http://www.pico-8.com
version 8
__lua__
--yo this is tom
--code goes here
--totally inspired by johannes richter's guide on picozine 2
--thank you johannes richter

--yo this is tom
--code goes here
--totally inspired by johannes richter's guide on picozine 2
--thank you johannes richter

function _init()
 winmusic=false
 pat=0 --state timer for player
 at=0 --timer for attack
 px=20
 py=64
 pstate=0 --current state
 pspr=20 --current sprite
 pdir=0 --current direction
 aspr=217 --attack sprite
 musicnotespr=211
 camerax=0
 actors={}
 ephem={}
 score=0
 sequence={2,2,3,4,4,4,3,2,5,6,6,5,2,2,5,5,6,6}
 issinging=false

 add_actors()
 objectives=#actors
end

function _draw()
 cls()
 --draw the world 
 map(camerax/8,0,camerax-camerax%8,0,17,17)



 foreach(actors, draw_actor)

 --draw the player
 drawhud()
 spr(pspr,px,py,1,1,pdir==-1)

 --draw the attack
 if(btn(4))spr(musicnotespr, px, py-8, 1, 1, false)
 if(btn(4) and pdir==1) then
  spr(aspr, px+8, py, 1, 1, false)
 elseif(btn(4) and pdir==-1) then
  spr(aspr, px-8, py, 1, 1, true)
 end
  
 foreach(ephem, ephem_update)
end

function _update()
 b0=btn(0)
 b1=btn(1)
 b2=btn(5) or btn(2)
 b4=btn(4)
 wassinging = issinging
 pat+=1

 if(at>10 and at<20) then
  aspr=217
  musicnotespr=211
 end
 if(at>20 and at<30) then 
  aspr=218
  musicnotespr=212
 end
 if(at>30 and at<40) then 
  aspr=219
  musicnotespr=213
 end
 if(at>40) then 
  aspr=220
  musicnotespr=214
 end
 if at>50 then 
  at=0
  aspr=221
 end 

 if(b4) then
  at+=1
 else  
  at = 0
  if(musicnotespr>212)musicnotespr=210
  aspr=221
 end

 --idle state
 if pstate==0 then
  if b4 then
   pspr=36
   issinging=true
  else 
   pspr=20
   sfx(-1, 3)
   issinging=false
  end
  if(b0 or b1)change_state(1)
  if(canfall()) then change_state(2)
  elseif(b2) then
   sfx(0)
   change_state(3)
  end
 end
 
 --walk state
 if pstate==1 then
  if (b0) pdir=-1   
  if (b1) pdir=1
  xmove=pdir*min(pat,2)
  if(px+xmove < 71*8)px+=xmove
  scrollscreen(xmove)
  if b4 then
   pspr=flr(pat/2)%2+39
   issinging=true
  else 
   issinging=false
   sfx(-1, 3)
   pspr=flr(pat/2)%2+23
  end
  if(not(b0 or b1))change_state(0)--go back to idle
  if(b2) then
   sfx(0)
   change_state(3)--go to jump
  end
  if(canfall())change_state(2)--drop if is in the air
 end

  --jump state
 if pstate==3 then
  if b4 then 
   pspr=37
   issinging=true
  else
   pspr = 21 
   issinging=false
   sfx(-1, 3)
  end
  py-=6-pat
  if (b0) then
   px-=2
   scrollscreen(-2)
  end
  if (b1) then
   px+=2
   scrollscreen(2)
  end
  if (not b2 or pat>7) change_state(0) end

 
 -- fall state
 if pstate==2 then
  if b4 then 
   issinging = true
   pspr=38 
  else
   issinging=false
   pspr = 22
   sfx(-1, 3)
  end
  if (canfall()) then
   if (b0) then
    px-=1
    scrollscreen(-1)
   end
   if (b1) then
    px+=1
    scrollscreen(1)
   end
   py+=min(4,pat) -- move the player
   if (not canfall()) py=flr(py/8)*8 -- check ground contact 
  else   
   py=flr(py/8)*8 -- fix position when we hit ground
   change_state(0)
  end
 end

 if(not(wassinging)and issinging) then
  sfx(1, 3)
 elseif(wassinging and not (issinging)) then
  sfx(-1, 3)
 end

 foreach(actors, actor_behave)
 foreach(actors, actor_collide)
end

function scrollscreen(x)
 if px>=65*8 then
  camerax=57*8    
  camera(camerax,y)
 elseif px > 63 then --scroll only midscreen-ish
  camerax+=x
  camera(camerax,0)
 elseif px<=63 then
  camerax = 0
  camera(camerax,y)
   
 end
end

function drawhud()
 if(score < objectives) then
  spr(48,camerax+128-8*3,128-(8*2)+1,1,1)
  print("sing(c) to cheer up sad do", camerax, 128-(6*2))

  spr(45,camerax+128-8*3,128-(8*1),1,1)
  print("jump(x) and get the notes", camerax, 128-(6*1))
 else
 	if(not winmusic) then
 		sfx(8)
 		winmusic=true
 	end
  print(" thank you for playing ", camerax, 128-(6*2))
 end
end

function canfall()
 --step one, get map tile under player feet
 v = mget(flr((px+4)/8), flr((py+8)/8))
 --step two, see if it's flagged as wall
 return not fget(v,1)
end

--0 idle, 1 walk, 2 drop, 3 jump
function change_state(s)
 pstate=s
 pat=0
end

--here i paste or edited some code taken from super poulet poulet by matt riche
--http://www.lexaloffle.com/bbs/?tid=2393
--it's great and pretty, play it

function add_actors()
 -- mgets all tiles, looking for actor flags.
 -- if flagged as actor, empty tile must be written
 -- if actor flag found, is added to the list.
 -- actors without "onscreen" flag set don't move
 del(actors)

 for ix = 0,128 do
  for iy = 0,14 do
   flagval = mget(ix,iy)
   if (fget(flagval, 7) == true) then
    make_actor(actors, flagval, ix, iy)
    mset(ix,iy, 0)
   end
  end
 end 
end

function clean_actors(a)
 
 del(actors, a) 
end

function make_actor(a,type,x,y)
 local a={}
 a.type = type
 a.sprite = type
 a.x = (x * 8)
 a.y = (y * 8)
 a.ax = 0
 a.ay = 0
 a.alive = true
 a.relevant = true
 a.airborne = false
 a.grounded = false
 a.animspeed = 3 -- lower is faster
 a.ticker = 0
 a.frame = 0
 a.speed = .2
 a.behave = 0
 a.prize = false
 a.tetherx = 0
 a.tethery = 0

 if(type==29 or type==45 or type==27 or type==28) then
  a.airborne=true
  a.frame=rnd(1)
 end

 add(actors, a)
 return a
end

function actor_collide(a)
 --check attack collision
 if(b4) then
  if (a.x > (px - 16)) and (a.x < (px + 16)) then
   if (a.y > (py - 16)) and (a.y < (py + 16)) then
    if(at>40 and a.type==48 ) then
     --befriend the enemy
     sfx(7)
     a.type=32
     make_twinkle(a.x+8,a.y-8, 4, 52)
     score += 1 
    end
   end
  end
 end

 --  if the player is hitting this actor
 if (a.x > (px - 8)) and (a.x < (px + 8)) then
  if (a.y > (py - 8)) and (a.y < (py + 8)) then
   if(a.type==29 or a.type==45 or a.type==57 or a.type==60) then
    note=sequence[1]
    del(sequence,note) --shift the sequence
    add(sequence,note)
    sfx(note)
    a.type = 0
    a.alive = false
    make_twinkle(a.x, a.y, 4, 9)
    score += 1  
   end
  end
 end
end
 
function make_twinkle(x, y, amount, sprnb)
 for i = 1, amount do
  make_ephem(ephem, x, y, sprnb)
 end
end

function make_ephem(e,x,y,k)
 local e = {}
 -- k for kind!
 e.k = k
 e.x = x
 e.y = y
 e.ax = 0
 e.ay = 0
 -- lower the better
 e.animspeed = 5
 e.frame = 0
 -- randomize the direction
 e.ax += (-(rnd(.5)))
 e.ax += rnd(.5)
 e.ay += (-(rnd(.5)))
 e.ay += rnd(.5)

 add(ephem, e) 
end


function ephem_update(e)
 e.x += e.ax
 e.y += e.ay

 e.animspeed -= 1
 
 if(e.animspeed <= 0) then
  e.frame += 1
  e.animspeed = 5
 end
 
 if (e.frame > 3) then
  del(ephem, e) 
 end 
 
 spr((e.k + e.frame), e.x, e.y)
end

function draw_actor(a)
 -- if an actor is "relevant," draw it.
 if(a.alive == false) then
  return
 end
 
 if(a.relevant) then

  if a.currentanim == 1 then
   if a.frame == 0 then 
    a.sprite = a.type
   end 
   if a.frame == 1 then 
    a.sprite = (a.type + 1)
   end 
   if a.frame == 2 then 
    a.sprite = a.type
   end 
   if a.frame == 3 then 
    a.sprite = (a.type + 2)
   end 
  end 
  
  a.ticker += 1
  if a.ticker >= a.animspeed then
   a.ticker = 0
   a.frame += 1
   if a.frame > 3 then
    a.frame = 0
   end
  end 
    
  spr(a.sprite, a.x, a.y, 1, 1, a.flip)

 end
end

function actor_behave(a)
 -- run behaviours on given actor id
 if (a.alive == false) then
  return
 end
 
 if ((a.x + 8)< camerax) or (a.x > (camerax + 128)) then
  a.relevant = false
 else
  a.relevant = true
 end

 if a.relevant == false then
  -- if not on screen, skip whole function
  return
 end

 if(a.type==29 or a.type==45 or a.type==57 or a.type==60 or a.type==48 or a.type==32) then
  a.currentanim = 1
 end
end


__gfx__
00000000077777000007770000077700077777000000000000000000000000000077770a00000000000000000000000000000000000000000000000000000000
00000000777777700077777000777770777777700000000000000000000000000777777a00000000000000000000000000000000000000000000000000000000
000000007fffff70077fff70077fff707fffff7000000000000000000000000007ffff7a0000000000070000000c000000000000000000000000000000000000
00000000ff0f0f0007f0f07007f0f070ff0f0f00000000000000000000000000f7f0f07f00000000007c7000000d0000000c0000000000000000000000000000
00000000ffffff0a07ffff0007ffff00ffffff0a0000000000000000000000005fffff000007700007cdc7000cd7dc0000c7c000000070000000000000000000
000000005575550a00575000005750005575550a0000000000000000000000005057500000077000007c7000000d0000000c0000000000000000000000000000
000000005575505f05575f0005575f005575505f000000000000000000000000055750000000000000070000000c000000000000000000000000000000000000
00000000050500005560600055606000050500000000000000000000000000000060600000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000004444400044444040444440004444400044444000000000000000000000000000000000000000000000000000000000
000000000000000007777000000777000444fff40444fff44444fff40444fff40444fff400000000000000000000000000000000000000000000000000000000
00000000000000007777770000777770444f5f54444f5f54444f5f54444f5f54444f5f540000000000000000000000000000000000ccc700007ccc00007ccc00
000000000000000077fff700077fff7a44ff5f5444ff5f5444ff5f5444ff5f5444ff5f540000000000000000000000000000000000700c0000c0070000c00700
00000000000000007f0f070a07f0f07a44fffff044fffff004fffff044fffff040fffff00000000000000000000000000000000000c00c0000c00c0000c00c00
00000000000000007ffff0a007ffff0a0488f8004088f8008088f8000488f8008888f8000000000000000000000000000000000007c07c000c70c7000c70c700
000000000000000005575f000055755f0088880008888800088888008888880006888800000000000000000000000000000000000c70cc0007c07c0007c07c00
00000000000000000600600000600600088606008600006006000060006000600000060000000000000000000000000000000000000000000000000000000000
0ccd00cd00cd0cd00000000000000000004444400044444040444440004444400044444000000000000000000000000000000000000000000000000000000000
0cacdcad00cadad00ccd00cd000000000444fff40444fff44444fff40444fff40444fff4000000000000000000000000000000000000c0000000c0000000c000
0ccccccd00ccccd00cacdcad0000000044455f5444455f5444455f5444455f5444455f540000000000000000000000000000000000007c000000c7000000c700
0cacccad00cacad00ccccccd0000000044ffeef444ffeef444ffeef444ffeef444ffeef4000000000000000000000000000000000000c0c00000c0c00000c0c0
0ccaaacd00ccacd00cacccad0000000044ffeef044ffeef004ffeef044ffeef040ffeef0000000000000000000000000000000000000c0000000c0000000c000
0cd000cd00cd0cd00ccaaacd000000000488f80f4088f80f8088f80f0488f80f8888f80f00000000000000000000000000000000007cc00000c7c00000c7c000
ccd00ccd0ccdccd00cd000cd0000000000888800088888000888880088888800068888000000000000000000000000000000000000cc7000007cc000007cc000
ccd00ccd0ccdccd0ccd00ccd00000000088606008600006006000060006000600000060000000000000000000000000000000000000000000000000000000000
08820082008208200000000000cd0cd000000000000000000000000000000000000000000000000000000000000000000c00c0000c00c0000c00c00000000000
08a828a2008a2a200882008200cadad0000000000002020000000000000000000000000000ccc00000c7c00000c7c0000c070700070c0c00070c0c0000000000
088888820088882008a828a200ccccd000000000002e2e2000ee0ee0000e0e00000000000700070c0c000c0c0c000c0c0c000c000c000c000c000c0000000000
088aaa820088a8200888888200cacad000000000002eee2000ee7ee0000070000000700000c00c0000c00c0000c00c000c0cc0000c07c0000c07c00000000000
08a888a2008a8a20088aaa8200ccacd000077000002eee20000eee00000e0e000000000000c70c07007c070c007c070c070070000c00c0000c00c00000000000
082000820082082008a888a200cd0cd0000770000002e2000000e000000000000000000000000c0000000c0000000c0007000c00070007000700070000000000
8820088208828820082000820ccdccd00000000000002000000000000000000000000000000c70000007c0000007c0000c0c0c00070c0c00070c0c0000000000
8820088208828820882008820ccdccd0000000000000000000000000000000000000000000c0000000c0000000c000000c0070000c00c0000c00c00000000000
11111117111111110001111100000000000000000000000008000000000000000007777700000000000000000000000000000000000000000000000000000000
111111111111111100017171000000000000000000000001110000000000000000777777000000000000000000000000000000000000000000000d0000dd0000
17111711171117110001111100000000000000000000001101000000000000000777777700000000000000000000000000000000000a000000dddddd0dd1ddd0
1111111111111111000171710000100000000080000001101110000000000000777777700000000000000000000a0000000a000000000000dddddd1ddd1ddddd
11171117111717110001111100011100000000100001111000000000000000007777700000000000000000000000000000000000000000000dd11ddddddddd1d
111111111111111100011111001111100000001000011110000000000000000777777000000000000000a00000000000000000000000000000ddd1d00dddd11d
17111711171117110001117181111118000011110000110000000000000000077777000000000000000000000000000000000000000000000000dd0000d0ddd0
111111111111111100011111111111110001111100811110000000000000007777000000000000000000000000000000000000a0000000000000000000000000
17171111111111110011111111111117001117110111711000000000000007777000000000000000000000000000000000000000000000000000000000000000
11111111111111110011111111111111001111110111111000000000001177700000000000000000000000000000000000000000000000a00000000000000000
11171117171117110011111117111711001117110111711000000000011777700000000000000000000000000000000000000000000000000000000000000000
111111111111111100111111111111110011111101111110000000001177700000000000000000000000000000000000000a0000000000000000000000000000
17111117111717110017111111171117001711110171111000000000117770000000000000000000000000000000000000000000000000000000000000000000
111111111111111100111111111111110011111101111110000000001117000000000000000000000000000000000000000000000000a0000000000000000000
11111117171117110011171117111711001117110111711000000000011100000000000000000000000000000000000000000a00000000000000000000000000
11111111111111110011111111111111001111110111111000000000011110000000000000000000000000000000000000000000000000000000000000000000
17171117171111110111111117171117011111110000000000000000111111171111111100000000000000000000000000000000000000000000000000000000
11111111111111110171111111111111017111110000000000000000111111111111111100000000000000000000000000000000000000000000000000000000
11171111171117110111711111171111011171110000000000000000171117111711171100000000000000000000000000000000000000000000000000000000
11111111111111110111111111111111011111110000000000000000111111111111111100000000000000000000000000000000000000000000000000000000
17111117111717110111717117111117011171710000000000000000111711171117171100000000000000000000000000000000000000000000000000000000
11111111111111110111111111111111011111110000000000000000111111111111111100000000000000000000000000000000000000000000000000000000
11171711111717110171711111171711017171110000000000000000171117111711171100000000000000000000000000000000000000000000000000000000
11111111111111110111111111111111011111110000000000000000111111111111111100000000000000000000000000000000000000000000000000000000
11111117111111111111111100000000000000000000000000000000171711111111111100000000000000000000000000000000000000000000000000000000
11111111111111111111111100000000000000000000000000000000111111111111111100000000000000000000000000000000000000000000000000000000
17111717171111111711111100000000000000000000080000000000111711171711171100000000000000000000000000000000000000000000000000000000
11111111111111111111111100001000000000000001110000000000111111111111111100000000000000000000000000000000000000000000000000000000
17111111111711111117111100011100008000000011010000000000171111171117171100000000000000000000000000000000000000000000000000000000
11111111111111111111111100111110001000000110010000000000111111111111111100000000000000000000000000000000000000000000000000000000
11171717171117111711171181111118011000001100111000000000111111171711171108000080000000000000000000000000000000000000000000000000
11111111111111111111111111111111111100001110000000000000111111111111111111111111000000000000000000000000000000000000000000000000
ddddddd7000000000000000000000000000000000444000000000000000000000000000000000000000000000000000000000000000000111100000000000000
1ddddd7d000000000000000000000000000000004444000000000000000000000000000000000000000000000000000000000000001111111111117700000000
115555dd00000000000000000000000000000004f444300000000000000000000000000000000000000000000000000000000000011111111111117700000000
115555dd00000000000000000000000000000006f433300000000000000000000000000000000000000000000000000000000001111111111111117770000000
115555dd000000000000000000000000000000066400000000000000000000000000000000000000000000000000000000000111111111111111117777700000
115555dd000000000000000000000000000000046600000000000000000000000000000000000000000000000000000000001111111111111111111777770000
1222225d00000000000000000000000000000006f600000000000000000000000000000000000000000000000000000000001111111111111111111777777000
22222225000000000000000000000000000000046640000000000000000000000000000000000000000000000000000000111111111111111111111177777700
00000000000000000000000000000000000000046640000000000000000000000000000000000000000000000000000000111111111111111111111177777700
00000000000000000000000000000000000000004640000000000000000000000000000000000000000000000000000001111111111111111111111117777770
00000000000000000000000000000000000000004640000000000000000000000000000000000000000000000000000001111111111111111111111117777770
00000000000000000000000000000000000000006440000000000000000000000000000000000000000000000000000011111111111111111111111117777777
00000000000000000000000000000000000000000440000000000000000000000000000000000000000000000000000011111111111111111111111117777777
00000000000000000000000000000000000000004640000000000000000000000000000000000000000000000000000011111111111111111111111177777777
0000000000000000000000000000000000000006f644000000000000000000000000000000000000000000000000000011111111111111111111111177777777
000000000000000000000000000000000000000fff64000000000000000000000000000000000000000000000000000011111111111111111111111177777777
000000000000000000000000000000000000000ffff4000000000000000000000000000000000000000000000000000011111111111111111111111177777777
000000000000000000000000000000000000000ffff4000000000000000000000000000000000000000000000000000011111111111111111111111177777777
000000000000000000000000000000000000000ffff6400000000000000000000000000000000000000000000000000077111111111111111111111777777777
00000000000000000000000000000000000000099994000000000000000000000000000000000000000000000000000077711111111111111111117777777777
00000000000000000000000000000000000000484444000000000000000000000000000000000000000000000000000077777111111111111111177777777777
00000000000000000000000000000000000000044444400000000000000000000000000000000000000000000000000077777711111111111111777777777777
00000000000000000000000000000000000000044444400000000000000000000000000000000000000000000000000007777777711111111177777777777777
00000000000000000000000000000000000000044444400000000000000000000000000000000000000000000000000007777777771111777777777777777770
00000000000000000000000000000000000000064489400000000000000000000000000000000000000000000000000007777777777777777777777777777770
00000000000000000000000000000000000000064444440000000000000000000000000000000000000000000000000000777777777777777777777777777700
00000000000000000000000000000000000000474449440000000000000000000000000000000000000000000000000000777777777777777777777777777700
00000000000000000000000000000000000000774449440000000000000000000000000000000000000000000000000000077777777777777777777777770000
00000000000000000000000000000000440047664489440000000000000000000000000000000000000000000000000000007777777777777777777777700000
00000000000000000000000000000000667774444449944044000000000000000000000000000000000000000000000000000777777777777777777777000000
00000000000000000000000000000004666644009488944444400000000000000000000000000000000000000000000000000077777777777777777770000000
00000000000000000000000000000004444440049989988448400000000000000000000000000000000000000000000000000000777777777777000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000cccccc000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000cccccc0c000000c00000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000cccccc0c000000c0000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000cccccc0c000000c000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000c000000c00000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000009999200099992000997a2000999920009a79200c0c00c000c0c00c0000000000000000000000000000000c0000000000000000000000000
00000000000000000a207292092072a2072092a209209292072072a20c0c00c000c0c00c00000000000000000000c0000000c00c000000000000000000000000
0000000000000000a727a27aaa29a2999a29a2999729929a7a29a29a0c0c00c000c0c00c0000000000c0000000c00c0000c00c0c000000000000000000000000
00000000000000007a2792729a29929299299272a92a7292992992a20c0c00c000c0c00c00000000000c0000000c0c00000c0c0c000000000000000000000000
0000000000000000000000920000009200000092000000a2000000a20c0c00c000c0c00c0c0000000c0c00000c0c0c000c0c0c0c000000000000000000000000
00000000000000000000a7920000997200009a9200009992000099720c0c00c000c0c00c00000000000c0000000c0c00000c0c0c000000000000000000000000
00000000000000000000772000009920000079200000a920000099200c0c00c000c0c00c0000000000c0000000c00c0000c00c0c000000000000000000000000
00000000000000000000000000000000000000000000000000000000c0c00c000c0c00c000000000000000000000c0000000c0c0000000000000000000000000
0000000000000000000000000000000000000000c000000c00000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000cccccc0c000000c000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000cccccc0c000000c0000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000cccccc0c000000c00000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000cccccc000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__label__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111770000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111770000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111777000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111777770000000
00000000000000000000000000000000000000000000000000000000000000000000000000a00000000000000000000000111111111111111111177777000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111177777700000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111117777770000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111117777770000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111777777000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111777777000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111777777700
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111777777700
00000000000000000000000000a0000000000000000000000000000000a00000000000000000000000a000000000001111111111111111111111117777777700
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111117777777700
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111117777777700
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111117777777700
dd000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111117777777700
d1ddd000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007711111111111111111111177777777700
1ddddd00000000000000000000000000000000000000000000000000000000000000000000000000000000000000007771111111111111111111777777777700
dddd1d00000000000000000000000000000000000000000000000000000000000000000000000000000000000000007777711111111111111117777777777700
ddd11d00000000000000000000a00000000000000000000000000000000000000000000000000000000000000000007777771111111111111177777777777700
d0ddd000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000777777771111111117777777777777700
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000777777777111177777777777777777000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000777777777777777777777777777777000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777777777777777777777770000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777777777777777777777770000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007777777777777777777777777000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000777777777777777777777770000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777777777777777700000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007777777777777777777000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777777777777770000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000800000008000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000111100000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110001111100000000000000000000000000
00000000000000000000000882008200000000000000000000000000000000009a79200000000000000000111111111111111100000000000000000000000000
000000000000000000000008a828a2000000000000000000000000000000000072072a2000000000000000111111111111111100000000000000000000000000
0000000000000000000000088888820000000000000000000000000000000007a29a29a000000000000000171117111711111100000000000000000000000000
0000000000000000000000088aaa82000000000000000000000000000000000992992a2000000000000000111111111111111100000000000000000000000000
000000000000000000000008a888a2000000000000000000000000000000000000000a2000000000000000111717111117111100000000000000000000000000
00000000000000000000000820008200000000000000000000000000000000000009972000000000000000111111111111111100000000000000000000000000
00000000000000000000008820088200000000000000000000000000000000000009920000000000000000171117111711171100000000000000000000000000
00000000000000000000008820088200000000000000000000000000000000000000000000000000000000111111111111111100000000000000000000000000
0000000000000000000000ddddddd7ddddddd7ddddddd70000000000000000000444440000000c00000000111111111111111100000000000000000000000000
00000000000000000000001ddddd7d1ddddd7d1ddddd7d000000000ccd00cd00444fff40000c00c00000001111111111111111000000000000000000000d0000
0000000000000000000000115555dd115555dd115555dd000000000cacdcad044455f5400c00c0c00000001711171117111111000000000000000000dddddd0d
0000000000000000000000115555dd115555dd115555dd000000000ccccccd044ffeef4000c0c0c000000011111111111111110000000000000000dddddd1ddd
0000000000000000000000115555dd115555dd115555dd000000000cacccad044ffeef00c0c0c0c0000000111717111117111100000000000000000dd11ddddd
0000000000000000000000115555dd115555dd115555dd000000000ccaaacd00488f80f000c0c0c00000001111111111111111000000000000000000ddd1d00d
00000000000000000000001222225d1222225d1222225d000000000cd000cd00088880000c00c0c0000000171117111711171100000000000000000000dd0000
000000000000000000000022222225222222252222222500000000ccd00ccd0088606000000c0c00000000111111111111111100000000000000000000000000
0000000000000008820082000000000000000000000000ddddddd7ddddddd7ddddddd70000000000000000111111111111111100000000000000000000000000
0000000000000008a828a20000000000000000000000001ddddd7d1ddddd7d1ddddd7d0000000000000000111111111111111100000000000000000000000000
0000000000000008888882000000000000000000000000115555dd115555dd115555dd0000000000000000171117111711111100000000000000000000000000
00000000000000088aaa82000000000000000000000000115555dd115555dd115555dd0000000000000000111111111111111100000000000000000000000000
0000000000000008a888a2000000000000000000000000115555dd115555dd115555dd0000000000000000111717111117111100000000000000000000000000
0000000000000008200082000000000000000000000000115555dd115555dd115555dd0000000000000000111111111111111100000000000000000000000000
00000000000000882008820000000000000000000000001222225d1222225d1222225d0000000000000000171117111711171100000000000000000000000000
00000000000000882008820000000000000000000000002222222522222225222222250000000000000000111111111111111100000000000000000000000000
000000ddddddd7ddddddd70000000000000000000000000000000000000000000000000000000000000000111111111111111100000000000000000000000000
0000001ddddd7d1ddddd7d0000000000000000000000000000000000000000000000000000000000000000111111111111111100000000000000000000000000
000000115555dd115555dd0000000000000000000000000000000000000000000000000000000000000000171117111711111100000000000000000000000000
000000115555dd115555dd0000100000001000000000000000000000000000000000000000000000000000111111111111111100000000000000000000000000
000000115555dd115555dd0001110000011100000000000000000000000000000000000000000000000000111717111117111100000000000000000000000000
000000115555dd115555dd0011111000111110000000000000000000000000000000000000000000000000111111111111111100000000000000000000000000
0000001222225d1222225d8111111881111118000000000000000000000000000000000000000000000000171117111711171100000000000000000000000000
00000022222225222222251111111111111111000000000000000000000000000000000000000000000000111111111111111100000000000000000000000000
ddddd700000000000000001111111111111111000000000000000000000000000000000000000000000000111111111111111100000000000000000000000000
dddd7d00000000000000001111111111111111000000000000000000000000000000000000000000000000111111111111111100000000000000000000000000
5555dd00000000000000001711171117111111000000000000000000000000000000000000000000000000171117111711111100000000000000000000000000
5555dd00000000000000001111111111111111000000000000008000001000000000000000000000000000111111111111111100000000000000000000000000
5555dd00000000000000001117171111171111000000000000001000011100000000000000000000000000111717111117111100000000000000000000000000
5555dd00000000000000001111111111111111000000000000001000111110000000000000000000000000111111111111111100000000000000000000000000
22225d00000000000000001711171117111711000000000000111181111118000000000000000000000000171117111711171100000000000000000000000000
22222500000000000000001111111111111111000000000001111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001111111111111111000000000011111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001111111111111111000000000011111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001711171117111111000000000011111117111711000000000000000000000000171117111711111100000000000000000000000000
00000000000000000000001111111111111111000000000011111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001117171111171111000000000017111111171711000000000000000000000000111717111117111100000000000000000000000000
00000000000000000000001111111111111111000000000011111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001711171117111711000000000011171117111711000000000000000000000000171117111711171100000000000000000000000000
00000000000000000000001111111111111111000000000011111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001111111111111111000000001111111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001111111111111111000000001111111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001711171117111111000000001711171117111111000000000000000000000000171117111711111100000000000000000000000000
00000000000000000000001111111111111111000000001111111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001117171111171111000000001117171111171111000000000000000000000000111717111117111100000000000000000000000000
00000000000000000000001111111111111111000000001111111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001711171117111711000000001711171117111711000000000000000000000000171117111711171100000000000000000000000000
00000000000000000000001111111111111111000000001111111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001111111111111111000000001111111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001111111111111111000000001111111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001711171117111111000000001711171117111111000000000000000000000000171117111711111100000000000000000000000000
00000000000000000000001111111111111111000000001111111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001117171111171111000000001117171111171111000000000000000000000000111717111117111100000000000000000000000000
00000000000000000000001111111111111111000000001111111111111111000000000000000000000000111111111111111100000000000000000000000000
00000000000000000000001711171117111711000000001711171117111711000000000000000000000000171117111711171100000000000000000000000000
00000000000000000000001111111111111111000000001111111111111111000000000000000000000000111111111111111100000000000000000000000000
ddddd7ddddddd7ddddddd7ddddddd7ddddddd7ddddddd7ddddddd7ddddddd7ddddddd7ddddddd7ddddddd7ddddddd7ddddddd7ddddddd7ddddddd7ddddddd7dd
dddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1ddddd7d1d
5555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd11
5555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd11
5555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd11
5555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd115555dd11
22225d1222225d1222225d1222225d1222225d1222225d1222225d1222225d1222225d1222225d1222225d1222225d1222225d1222225d1222225d1222225d12
22222522222225222222252222222522222225222222252222222522222225222222252222222522222225222222252222222522222225222222252222222522
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000088200820000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008a828a20000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000088888820000000000000000
06606660660006600600606006000000666006600000066060606660666066600000606066600000066066606600000066000660088aaa820000000000000000
6000060060606000600060600060000006006060000060006060600060006060000060606060000060006060606000006060606008a888a20000000000000000
66600600606060006000606000600000060060600000600066606600660066000000606066600000666066606060000060606060082000820000000000000000
00600600606060606000666000600000060060600000600060606000600060600000606060000000006060606060000060606060882008820000000000000000
66006660606066600600666006000000060066000000066060606660666060600000066060000000660060606660000066606600882008820000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c0000000000000000000
6660606066606660060060600600000066606600660000000660666066600000666060606660000066000660666066600660000000007c000000000000000000
060060606660606060006060006000006060606060600000600060000600000006006060600000006060606006006000600000000000c0c00000000000000000
060060606060666060000600006000006660606060600000600066000600000006006660660000006060606006006600666000000000c0000000000000000000
06006060606060006000606000600000606060606060000060606000060000000600606060000000606060600600600000600000007cc0000000000000000000
6600066060606000060060600600000060606060666000006660666006000000060060606660000060606600060066606600000000cc70000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000

__gff__
0000000000000000000000000000000000000000000000000000000000808080808080000000000000000000008080808080800000000000008080808080800000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
0000004c0000004c4748004e4f000000000000000000000000000000000000000000000000000000004a00000000000000000000000000000000000000000000004a00008c8d8e8f4a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
4f4e81814e4f818157588181818181004a004a000000000000000000004a000000000000000000000000000000004e4f00004e4f4a0000000000004a0000004a00004a009c9d9e9fa04a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
797900000000000068416f004a000000000000004a004a0000000000000000004e4f00004a000000000000447300004a0000004a0000004e4f00004a0000000000000000acadaeafb00000004e4f0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
40416b6c5c6e4f4e6061000000004a004e4f004a00000000000000004a0000000000000000004a4a000000524100000000000000004a00000000000000391d2d2d000000bcbdbdbfc04a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
50517b7c7d7e6e814061818181818181000000000000004e4f000000000000391d1d2d1d000000004e4f0041410000000000000000000000000000001b00001c00000044440000c0c000004e4f000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
6061440505057e006861000000000000000000447300000000000000000000000000000000000000000000416100000000391d00000000001d0000300000000000000051710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
70714205050505057861004e4f0000000000005241000000003c1d2d1d2d0000000000000000000000000051712d000000002d000000001d0000008080800030000000517100004e4f000000004e4f00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
6061629b0505058150418181447345461d00004141000000000000000000008080808000000000001d0000414100001a00192d0000002d00001a30000000808080000051710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
7071727300000000505100005241411b0000004161391d2d0000192a30000000001d000000000000000000416100008080800000003c0000008080737300000000000051710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
404140410000000040512d00404161800000005171000000000080808080000000301c000000001919300051718000000000000000000000800000517100447300000051710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
5051505100000000507100005051713c1d2d2d41410019000000000000000000008080800000008080800041410000000000000000301980000000517100524100000051710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
606160616b6c6d0061808100608080808080004161008080808000000000000000000000000000000000804180003c1d1d1d2d0080808000000000517100517100000051710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
707170717b392d2d616100007071416b7b7b7b5171307b7b7b7b7b391d2d2d1d1d2d1d1d2d1d2d2d2d000051713000000000000000000000000000517100517100000051710000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
8080808080808080808080808080808080808080808080808080808080808080808080808080808080808080808080808080808080808080808080808080808080808080808080808000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b7b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__sfx__
0109000030241302063030134301343013230130301343013430132301353013730139301393013b3013c3012e3012c3012a3012a3012a3012a301170000f000170000f0000d000170000f000160000f0000d000
010d00203454234502345423450235542305023754237542325023754230502355423050234542345023254230502305423050230542305023254234502345423454230502325423254230502305423054230502
011000001c3401c3452350015500135002a5002b5002d5002f5003150033500227002d70032700000002f5000000000000235002d500000000000000000000001f70021700237002570026700237001f70000000
011000001d3401d3452350015500135002a5002b5002d5002f5003150033500227002d70032700000002f5000000000000235002d500000000000000000000001f70021700237002570026700237001f70000000
011000001f3401f345305053250500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001a3401a345003000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001834018345000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010800002434326345265452b545325552e6002b205282052b205282052b20528205292052b205282052b2052d205292052b205282052b205292052b205282052b205292052b205282052b205292052b20528205
011000001c7701c7051c7701d0001d7701f0001f7701f770007001f770000001d770000001c770000001a77018000187700000018770000001a770210001c7701c070007001a7701a77000000187700000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344

